#include <stdio.h>

#define MAXN 20000

typedef struct {
    double x, y;
    int id;
} Point;

Point tmp[MAXN];

void merge(Point *a, int l, int m, int r) {
    int i = l, j = m + 1, k = l;
    while (i <= m && j <= r) {
        if (a[i].x < a[j].x)
            tmp[k++] = a[i++];
        else
            tmp[k++] = a[j++];
    }
    while (i <= m) tmp[k++] = a[i++];
    while (j <= r) tmp[k++] = a[j++];
    for (i = l; i <= r; i++) a[i] = tmp[i];
}

void mergesort(Point *a, int l, int r) {
    if (l >= r) return;
    int m = (l + r) / 2;
    mergesort(a, l, m);
    mergesort(a, m + 1, r);
    merge(a, l, m, r);
}

int main() {
    int n;
    double eps;
    scanf("%d %lf", &n, &eps);

    Point p[MAXN];
    for (int i = 0; i < n; i++) {
        scanf("%lf %lf", &p[i].x, &p[i].y);
        p[i].id = i + 1;
    }

    Point q[MAXN];
    int m = 0;
    for (int i = 0; i < n; i++) {
        if (p[i].y < 0.5) {
            q[m++] = p[i];
        }
    }

    if (m == 0) {
        q[m++] = p[0];
    }

    mergesort(q, 0, m - 1);

    int step = 30;   
    int chosen[MAXN];
    int k = 0;

    for (int i = 0; i < m; i += step) {
        chosen[k++] = i;
    }

    if (k == 0) chosen[k++] = 0;

    printf("%d\n", k);
    for (int i = 0; i < k; i++)
        printf("%d ", q[chosen[i]].id);
    printf("\n");

    for (int i = 1; i < k; i++) {
        printf("%d %d\n",
               q[chosen[i - 1]].id,
               q[chosen[i]].id);
    }

    return 0;
}